var canvas = document.getElementById('clock');
var context = canvas.getContext('2d');

function drawClock() {
  var now = new Date();
  context.fillStyle = '#eeeeee';
  context.lineCap = 'round';

  // Draw the face and rim
  context.lineWidth = 2;
  context.beginPath();
  context.arc(100, 100, 99, 0, Math.PI*2, true);
  context.fill();
  context.stroke();

  // Draw the hour hand
  var angle = (Math.round(now.getHours()%12) + now.getMinutes()/60) / 
              (12 / (Math.PI*2));
  context.lineWidth = 7;
  context.save();
  context.translate(100, 100);
  context.rotate(angle);
  context.beginPath();
  context.moveTo(0, 4);
  context.lineTo(0, -50);
  context.stroke();
  context.rotate(-angle);
  context.restore();

  // Draw the minute hand
  angle = now.getMinutes() / (60 / (Math.PI*2));
  context.lineWidth = 3;
  context.save();
  context.translate(100, 100);
  context.rotate(angle);
  context.beginPath();
  context.moveTo(0, 10);
  context.lineTo(0, -80);
  context.stroke();
  context.restore();
};
setInterval(drawClock, 1000);
