// Ensure that the moonPhase namespace exists
var moonPhase = window.moonPhase || {};

// Override the default load method
moonPhase.defaultLoad = moonPhase.load;
moonPhase.load = function () {
  // Set the widget's visual style to match the preferred size
  if (moonPhase.prefs.size.get() === 'small') {
    document.body.style.width = '160px';
    document.body.style.backgroundImage = 'url(Default_small.png)'; 
    moonPhase.elements.config.style.height = '125px';
    moonPhase.elements.main.style.height = '132px';
    moonPhase.elements.moon.style.marginTop = '12px';
  } else {
    document.body.style.width = '240px';
    document.body.style.backgroundImage = 'url(Default.png)'; 
    moonPhase.elements.config.style.height = '185px';
    moonPhase.elements.main.style.height = '200px'; 
    moonPhase.elements.moon.style.marginTop = '';
  }

  // Call the default method
  moonPhase.defaultLoad();

  // Set up the Info Button
  moonPhase.elements.config_icon.style.backgroundImage = '';
  new AppleInfoButton(moonPhase.elements.config_icon, 
    moonPhase.elements.main, 'white', 'black', moonPhase.showConfig);
};

// Also override the default methods for showing and hiding the config pane to
// include Apple's flipping animation

moonPhase.defaultShowConfig = moonPhase.showConfig;
moonPhase.showConfig = function () {
  if (window.widget) {
    widget.prepareForTransition('ToBack');
  }
 
  moonPhase.defaultShowConfig();

  if (window.widget) {
    setTimeout('widget.performTransition();', 0);
  }
};

moonPhase.defaultHideConfig = moonPhase.hideConfig;
moonPhase.hideConfig = function () {
  if (window.widget) {
    widget.prepareForTransition('ToFront');
  }
 
  moonPhase.defaultHideConfig();

  if (window.widget) {
    setTimeout('widget.performTransition();', 0);
  }
};