if (crossPlatform.api === 'igoogle') {
  crossPlatform.emptyPref = '';
  crossPlatform.host = '';
  if (window._args instanceof Function) {
    crossPlatform.container = _args().synd || _args().container;
  }
  switch (crossPlatform.container) {
    case 'calendar':     break;
    case 'spreadsheets': break;
    case 'ig':        crossPlatform.container = 'igoogle';  break;
    case 'gm':        crossPlatform.container = 'mail';     break;
    case 'mpl':       crossPlatform.container = 'maps';     break;
    case 'gd':        crossPlatform.container = 'desktop';  break;
    case 'myaolgrs':  crossPlatform.container = 'my.aol';   break;
    case 'gasp2': 
      crossPlatform.container = 'start';
      crossPlatform.host      = _args().pid; 
      break;
    case 'enterprise': 
      crossPlatform.container = 'sites';
      crossPlatform.host      = document.referrer.split('/').splice(0, 2).join('/');
      break;
    default:
      if (/^navclient/.test(crossPlatform.host)) {
        // Catches any 'navclient_xx' hosts, known (ff, ie) or unknown
        crossPlatform.container = 'toolbar';
      } else {
        // Catches blank container strings, 'blogger', 'open', and any new ones
        crossPlatform.container = (crossPlatform.container || 'unknown');
        crossPlatform.host      = document.referrer.split('/')[2];
      }
  }
}