moonPhase.saveConfig = function () {
  var name, selector;

  try {
    for (name in moonPhase.prefs) {
      selector = moonPhase.elements[name]; 
      moonPhase.prefs[name].set(selector.options[selector.selectedIndex].value);
    }

    moonPhase.load();
  } catch (e) {
    alert('Unable to save settings: ' + e.message);
    if (!!window.console && !!console.log) {
      console.log(e.message);
    }
  }
  moonPhase.hideConfig();
};

moonPhase.loadConfig = function () {
  var name, value, selector, s;

  for (name in moonPhase.prefs) {
    value = moonPhase.prefs[name].get();
    selector = moonPhase.elements[name];
    for (s = 0; s < selector.length; s += 1) {
      selector.options[s].selected = (selector.options[s].value === value);
    }
  }
};
