crossPlatform.setCookie = function (name, value) {
  var mSecPerYear = 1000 * 60 * 60 * 24 * 365,
      cookieExpire;

  if (!value) {
    // Delete the cookie by setting an expiration date in the past 
    cookieExpire = 'Sun, 24-Apr-05 00:00:00 GMT';
  } else {
    // Upsert the cookie by setting an expiration date one year from now
    cookieExpire = (new Date(Number(new Date()) + mSecPerYear)).toUTCString();
  }
  
  document.cookie = name + '=' + value + ';expires=' + cookieExpire + 
                    ';path=' + window.location.pathname;
};

crossPlatform.getCookie = function (name) {
  var cookies = document.cookie.split(';'),
      thisCookie,
      c;
 
  // Iterate through the cookie list, returning the value associated with "name"
  name = name + '=';
  for (c = 0; c < cookies.length; c += 1) {
    thisCookie = cookies[c].replace(/^\s+/, '');
    if (thisCookie.indexOf(name) === 0) {
      return thisCookie.substring(name.length, thisCookie.length);
    }
  }
  // Target "name" not found
  return null;
};
