// fetchXML: Retrieve an XML document from url and pass it to callback as a DOM 
crossPlatform.fetchXML = function (url, callback) {
  crossPlatform.fetch(url, callback, 'responseXML');
};

// fetchText: Retrieve a text document from url and pass it to callback as a string 
crossPlatform.fetchText = function (url, callback) {
  crossPlatform.fetch(url, callback, 'responseText');
};

// Helper code for content-fetching routines 
crossPlatform.fetch = function (url, callback, propertyName) {
  var xhrFetcher = crossPlatform.getFetcher();
  if (!xhrFetcher) {
    // We were unable to create the XHR object
    callback(null);
  } else {
    xhrFetcher.open('GET', url, true);
    xhrFetcher.onreadystatechange = function () {
      if (xhrFetcher.readyState === 4) {
        // Retrieval complete
        if (!!xhrFetcher.timeout) {
          clearTimeout(xhrFetcher.timeout);
        }
        if (xhrFetcher.status >= 400) {
          // Returned an HTTP error
          callback(null);
        } else {
          // Returned successfully
          callback(xhrFetcher[propertyName]);
        }
        // We're done with this fetcher object
        crossPlatform.fetchers.push(xhrFetcher);
      }
    };
    xhrFetcher.timeout = setTimeout(callback, 60000);
    xhrFetcher.send(null);
  }
};
crossPlatform.fetchers = [];
crossPlatform.getFetcher = function () {
  if (!!crossPlatform.fetchers.length) {
    return crossPlatform.fetchers.pop();
  } else {
    if (!!window.XMLHttpRequest) {
      return new XMLHttpRequest(); // Most browsers
    } else if (!!window.ActiveXObject) {
      return new ActiveXObject('Microsoft.XMLHTTP'); // Some IE
    } else {
      return null;  // Really old browser
    }
  }
};

// nodeValue: Extract the text value of a DOM node
crossPlatform.nodeValue = function(node) {
  return (node.innerText || node.text || node.textContent || 
          node.childNodes.length ? node.childNodes[0].data : null);
};
