<?php
/*
 * last_next.js.php
 * Created on 9-Apr-2009
 *
 */

  define('CYCLE_LENGTH',  29.530588853);
  define('SECS_PER_DAY', 24 * 60 * 60);
  
  function normalize($v) {
    $v = $v - floor($v); 
    if ($v < 0)
        $v = $v + 1;

    return $v;
  }

  function ffMoonPhase($dtmWhen) {
    $JD = gregoriantojd(date('m', $dtmWhen), date('d', $dtmWhen), date('Y', $dtmWhen)) + ($dtmWhen % SECS_PER_DAY) / SECS_PER_DAY;// date('H', $dtmWhen) / 24;
//echo "$JD\n";
    // calculate moon's age in days
    return normalize(($JD - 2451550.1 - 0.1674369994) / CYCLE_LENGTH) * CYCLE_LENGTH;
  }

  $dtmWhen = mktime();//0, 0, 0, 4, 11);
  $fAge = ffMoonPhase($dtmWhen);
//echo "$fAge\n";

  if ($fAge < CYCLE_LENGTH / 2) {
    $sLast = 'New';
    $sNext = 'Full';
    $fLast = $fAge;
    $fNext = (CYCLE_LENGTH / 2) - $fAge;
  } else {
    $sLast = 'Full';
    $sNext = 'New';
    $fLast = $fAge - (CYCLE_LENGTH / 2);
    $fNext = CYCLE_LENGTH - $fAge;
  }
  
  $dtmLast = round(($dtmWhen - ($fLast * SECS_PER_DAY)) * 1000);
  $dtmNext = round(($dtmWhen + ($fNext * SECS_PER_DAY)) * 1000);

//  header('Content-type: text/plain');
//  echo "{
//  'last': {'type': '$sLast', 'when': $dtmLast}, 
//  'next': {'type': '$sNext', 'when': $dtmNext}
//}";

  header('Content-Type: text/xml');
  echo "<moon>
  <phase type=\"$sLast\">$dtmLast</phase>
  <phase type=\"$sNext\">$dtmNext</phase>
</moon>";
?>

