/*jslint browser: true, onevar: true, plusplus: true, eqeqeq: true, bitwise: true, nomen: false */
/*global window */

// The crossPlatform namespace
var crossPlatform = window.crossPlatform || {};

// Initialize an XHR object for later use
if (!!window.XMLHttpRequest) {
  crossPlatform.xhrFetcher = new XMLHttpRequest(); // Most browsers
} else if (!!window.ActiveXObject) {
  crossPlatform.xhrFetcher = new ActiveXObject('Microsoft.XMLHTTP'); // Some IE
}

// fetchXML: Retrieve an XML resource asynchronously
crossPlatform.fetchXML = function (url, callback) {
  if (!!crossPlatform.xhrFetcher) {
    crossPlatform.xhrFetcher.open('GET', url, true);
    crossPlatform.xhrFetcher.onreadystatechange = function () {
      if (crossPlatform.xhrFetcher.readyState === 4) {
        // Retrieval complete
        if (crossPlatform.xhrFetcher.status >= 400) {
          // Returned an HTTP error
          callback(null);
        } else {
          // Returned successfully
          callback(crossPlatform.xhrFetcher.responseXML);
        }
      }
    };
    crossPlatform.xhrFetcher.send(null);
  } else {
    // We were unable to create the XHR object
    callback(null);
  }
};

// nodeValue: Extract the text value of a DOM node
crossPlatform.nodeValue = function(node) {
  return (node.innerText || node.text || node.textContent || 
          node.childNodes.length ? node.childNodes[0].data : null);

};

// getWidth/getHeight: Return the size in pixels of the window or a DOM element 
crossPlatform.getWidth = function (element) {
  if (element === window) {
    return document.body.offsetWidth || document.body.parentNode.clientWidth;
  } else {
    return element.offsetWidth || element.innerWidth;
  }
};
crossPlatform.getHeight = function (element) {
  if (element === window) {
    return document.body.offsetHeight || document.body.parentNode.clientHeight;
  } else {
    return element.offsetHeight || element.innerHeight || element.clientHeight;
  }
};

// addHandler: Attach a function as a handler to a DOM event
crossPlatform.addHandler = function (element, event, handler) {
  if (!!element.addEventListener) {
    // W3C DOM Level 2 compliant
    element.addEventListener(event, handler, false);
  } else {
    // Other browsers
    var oldHandler = element['on' + event];
    element['on' + event] = function() {
      if (!!oldHandler) {
        oldHandler();
      }
      handler();
    };
  }
};

// escapeHTML: Make a string safe for display within page content
crossPlatform.escapeHTML = function (text) {
  if (!!text) {
    text = String(text).replace(/'/g, '&apos;').replace(/"/g, '&quot;');
    text = text.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
  }
  return text; 
};
