/*jslint browser: true, onevar: true, plusplus: true, eqeqeq: true, bitwise: true, forin: true  */
/*global window, crossPlatform */

// The moonPhase namespace
var moonPhase = window.moonPhase || {};

// Declare module-level variables
moonPhase.nextLast = null;
moonPhase.timeout  = null;
moonPhase.elements = {
  'moon':   null,
  'last':   null,
  'next':   null,
  'credit': null
};

// init: Initialize the gadget
moonPhase.init = function () {
  // Links to XHTML elements 
  var id;
  for (id in moonPhase.elements) {
    moonPhase.elements[id] = document.getElementById(id);
  }

  // Attach (and call) the resize handler to load content
  crossPlatform.addHandler(window, 'resize', moonPhase.load);
  moonPhase.load();
};
crossPlatform.addHandler(window, 'load', moonPhase.init);

// load: Load the visible content appropriate for the current size of the gadget
moonPhase.load = function () {
  var width, size, imgSrc;

  // Get the sceen width
  width = crossPlatform.getWidth(window);

  if (width > 220) {
    // Show the ancillary text
    moonPhase.elements.last.style.display = 'inline';
    moonPhase.elements.next.style.display = 'inline';

    if (!moonPhase.nextLast ||
        (Number(new Date()) > moonPhase.nextLast.next.when)) { 
      // Retrieve the next/last data
      crossPlatform.fetchXML('http://daylightmap.com/moon/next_last.xml.php', 
          moonPhase.receiveNextLast);
    } else {
      // No retrieval necessary, just show it
      moonPhase.showText();
    }
  } else {
    // Hide the ancillary text
    moonPhase.elements.last.style.display = 'none';
    moonPhase.elements.next.style.display = 'none';
  }

  if (width < 180) {
    size = 'small';
  } else if (width < 800) {
    size = 'medium';
  } else {
    size = 'large';
  }
  if (size === 'large') {
    // Large display (for full-sized monitors) 
    imgSrc = 'luna_north_large.jpg';
    document.body.style.overflow = 'auto';
    moonPhase.elements.moon.height = 625;
    moonPhase.elements.moon.width  = 625;
  } else {
    // Ordinary gadget-sized siaplay
    imgSrc = 'luna_north_small.jpg';
    document.body.style.overflow = '';
  
    if (size === 'small') {
      // Small display
      moonPhase.elements.moon.height = 88;
      moonPhase.elements.moon.width  = 88;
    } else {
      // Medium-sized display
      moonPhase.elements.moon.height = 176;
      moonPhase.elements.moon.width  = 176;
    }
  }

  // Set the source for the main moon image
  moonPhase.elements.moon.src = 'http://daylightmap.com/moon/images/' + imgSrc;
};

// receiveNextLast: Callback for the next/last XML retrieval
moonPhase.receiveNextLast = function (responseXML) {
  var nodes;
  if (!responseXML) {
    // Error retrieving the data - try again, using exponential back-off with jitter
    moonPhase.delay = moonPhase.delay || 5 * 1000;
    // Give up after 4 failures.
    if (moonPhase.delay <= 40 * 1000) {
      moonPhase.delay *= 2;
      window.setTimeout(moonPhase.load, moonPhase.delay);
    }
  } else {
    // Cache the retrieved data into a JS variable and show it on screen 
    nodes = responseXML.getElementsByTagName('phase');
    try {
      moonPhase.nextLast = {
        'last': {'type': crossPlatform.escapeHTML(nodes[0].getAttribute('type')),
                 'when': crossPlatform.nodeValue(nodes[0])},
        'next': {'type': crossPlatform.escapeHTML(nodes[1].getAttribute('type')),
                 'when': crossPlatform.nodeValue(nodes[1])}
      };
    } catch (e) {
      moonPhase.nextLast = null;
    }
    moonPhase.showText();
  }
};

// showText: Extract the next/last data from the local cache to the visible HTML 
moonPhase.showText = function () {
  if (!!moonPhase.nextLast) {
    // Cache has been filled - go ahead!
    moonPhase.elements.last.innerHTML = moonPhase.nextLast.last.type + ' moon ' + 
      moonPhase.timeDelta(moonPhase.nextLast.last.when) + ' ago';
    moonPhase.elements.next.innerHTML = moonPhase.nextLast.next.type + ' moon in ' +
      moonPhase.timeDelta(moonPhase.nextLast.next.when);

    // Refresh the text display in 1 hour
    if (!!moonPhase.timeout) {
      window.clearTimeout(moonPhase.timeout);
    }
    moonPhase.timeout = window.setTimeout(moonPhase.load, 60 * 60 * 1000);
  }
};

// timeDelta: Generate a human-readable string showing the difference between the 
//            current time and the given JS Date object, as in "3 days, 22 hours" 
moonPhase.timeDelta = function (date)
{
  var days = Math.abs(date - Number(new Date())) / (24 * 60 * 60 * 1000), 
      hours = Math.round((days - Math.floor(days)) * 24), 
      result = '';

  if (Math.floor(hours) === 24) {
    days += 1;
    hours = 0;
  }

  if (days >= 1) {
    result = result + Math.floor(days) + '&nbsp;day';
    if (days >= 2) {
      result = result + 's';
    }
    result = result + ', ';
  }

  result = result + Math.floor(hours) + '&nbsp;hour';
  if (hours !== 1) {
    result = result + 's';
  }

  return result;
};
