<?php
  function save_image($image, $file_name) {
    if (file_exists($file_name))
      unlink($file_name);
    imagejpeg($image, $file_name);
  }

  // Generate current moon image with xplanet

  $file_name = 'luna_xlarge.png';
  if (file_exists($file_name))
    unlink($file_name);

  $xplanet = '/usr/local/bin/xplanet/xplanet';
  $xplanet .= ' -num_times 1 -body moon -origin earth -transpng '.$file_name.
               ' -geometry 1024x1024';

  exec($xplanet, $output, $return);
  if ($nReturn != 0) {
    echo "exec command failed with error $return <br />\n$xplanet";
    die;
  }

  // Prepare to generate images

  $source = imagecreatefrompng('luna_xlarge.png');
  imagesavealpha($source, true);
  $source_size = imagesx($source);

  $stars = imagecreatefromjpeg('stars_large.jpg');

  // Generate images in various sizes for both hemispheres

  $sizes = array('small' => 176, 'large' => 625);
  foreach ($sizes as $size_name => $dest_size) {
    $dest = imagecreatetruecolor($dest_size, $dest_size);
    imagecopy($dest, $stars, 0, 0, 5, 0, $dest_size, $dest_size);

    // Northern hemisphere
    imagecopyresampled($dest, $source, 0, 0, 0, 0, $dest_size, $dest_size,
                       $source_size, $source_size);
    fvSaveImage($dest, 'luna_north_'.$size_name.'.jpg');

    // Southern hemisphere
    $imDest = imagerotate($dest, 180, imagecolorallocate($dest, 0, 0, 0));
    fvSaveImage($dest, 'luna_south_'.$size_name.'.jpg');

    imagedestroy($dest);
  }

  // Cleanup
  imagedestroy($source);
  imagedestroy($stars);
?>